#GLM Prey% (GAMMA!)
#starting
setwd("~/Desktop/Tuli thesis/Statistics")
getwd()

#for repeatability, setting a seed to initialize a pseudo-random number generator. 
set.seed(1234)

DataGLM <- read.csv (file = "RegPrey.csv", header = TRUE, sep = ",")


#GLM Gamma family 
hist(DataGLM$prey.1)

GLMherd <- glm(formula = prey.1 ~ factor(herd), data = DataGLM, family = "Gamma")
summary(GLMherd)
anova (GLMherd,test="Chisq") #significant 

plot(prey.1 ~ factor(herd), data=DataGLM)

install.packages("emmeans")
library(emmeans)
marginal = emmeans(GLMherd, ~ factor(herd))
pairs(marginal)
cld(marginal, Letters=letters)

#variable biomass 

GLMbiomass <- glm(formula = prey.1 ~ biomass, data = DataGLM, family = "Gamma")
summary(GLMbiomass) #not significant 

ggplot(DataGLM, aes(x = biomass, y = prey.1)) + 
  geom_point(na.rm=TRUE, size = 2) + 
  geom_smooth(method = "lm", formula=y~poly(x,3), col = "blue") +  
  theme_classic() +
  xlab("biomass in kilograms") +
  ylab("proportion of prey in carnivores diet")

#variable availability 

GLMavailability <- glm(formula = prey.1 ~ availability , data = DataGLM, family="Gamma"(link='log'))
summary(GLMavailability)

plot(prey.1~availability, data=DataGLM)

ggplot(GLMavailability, aes(x = availability, y = prey.1)) + 
  geom_point(na.rm=TRUE, size = 2) + 
  geom_smooth(method = "lm", formula=y~poly(x,3), col = "blue") +  
  theme_classic() +
  xlab("availability of prey species") +
  ylab("proportion of prey in carnivores diet")
